function [ mfrsrdata ] = hiscale_importMFRSR()

cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\Peripheral Data\MFRSR');
currdir = dir;
mfrsr_time = [];

hemisp_broadband = [];
alltime_hemisp_broadband = [];
airmass = [];
azangle = [];
zenangle = [];

for i = 1:length(currdir)
	currfile = currdir(i).name;
	
	cdfcheck = contains(currfile,'.cdf') || contains(currfile,'.nc');
	if cdfcheck == 0
		continue
	end
	
	mfrsr_time = [mfrsr_time ; ARMtimeimport(currfile,15)];
	
	hemisp_broadband = [hemisp_broadband; ncread(currfile,'hemisp_broadband')];
	alltime_hemisp_broadband = [alltime_hemisp_broadband; ncread(currfile,'alltime_hemisp_broadband')];
	airmass = [airmass ; ncread(currfile,'airmass')];
	azangle = [azangle ; ncread(currfile,'azimuth_angle')];
	zenangle = [zenangle; ncread(currfile,'solar_zenith_angle')];
end

mfrsrdata.time = mfrsr_time;
mfrsrdata.hemisp_broadband = hemisp_broadband;
mfrsrdata.alltime_hemisp_broadband = alltime_hemisp_broadband;
mfrsrdata.airmass = airmass;
mfrsrdata.azangle = azangle;
mfrsrdata.zenangle = zenangle;


end